# Glass Cage: Zero-Click RCE and Kernel Takeover via Malicious PNG Exploit Chain (iOS 18.2.1)

**Prepared By:**  Joseph Goydish  II
**Date Submitted to Vendor:** December 18, 2024  
**CVE Identifiers:** CVE-2025-24085 (Core Media Privilege Escalation), CVE-2025-24201 (WebKit RCE), CVE-2025-43300
**Affected Devices:** iPhone 14 Pro Max, iOS 18.2.1  

---

## **1. Executive Summary**

This report consolidates analysis from three incident reports documenting a **zero-click remote code execution (RCE) chain** triggered by a **maliciously crafted PNG file sent via iMessage**. The attack chain leverages:

- WebKit parsing bugs for initial code execution.
- HEIF/ASTC decoder vulnerabilities in `ATXEncoder`.
- A sandbox bypass in `MessagesBlastDoorService`.
- Privilege escalation via Core Media memory corruption.
- Hardware-level manipulation via `mediaplaybackd`, `codecctl`, and IORegistry.
- Persistent compromise of system integrity including **network hijacking**, **keychain access**, and **device bricking**.

The exploit is **completely silent**, requiring **no user interaction**, and permits **persistent, root-level control** of the device.

---

## **2. Technical Impact**

- **Remote Code Execution (RCE)** via WebKit (CVE-2025-24201).
- **Privilege Escalation to kernel/root level** via Core Media (CVE-2025-24085).
- **Sandbox Escape** via malformed metadata in PNG files.
- **Keychain Access and Credential Theft**.
- **Persistent Network Hijack** via proxy override and `launchd` injection.
- **Complete Device Bricking** through manipulation of IODeviceTree.
- **Availability Impact** through resource exhaustion and service shutdowns.

---

## **3. Exploit Chain Analysis**

### **Stage 1: Malicious PNG Creation**

- **File Format:** PNG with embedded HEIF payload.
- **Vectors:** 
  - Metadata fields such as `Subsample`, `PixelXDimension`, and `PixelYDimension`.
  - Malformed EXIF to trigger heap corruption.
- **Key Bug Trigger:** Improper bounds checking in `ATXEncoder` during HEIF decoding.
- **Example Metadata Manipulation:**
  ```
  Subsample values: 1.000000
  Dimensions:
    Source: (234.0, 234.0)
    Destination: (175.0, 175.0)
  ```

---


⸻

### **Stage 2 — Delivery via iMessage (CVE-2025-43300)**

- **Delivery Method:** PNG container sent over iMessage.  
- **Zero-click Behavior:** On receipt, the system automatically stages the attachment and generates a thumbnail—no user interaction required.  
- **Trigger / Staging:** `MessagesBlastDoorService` unpacks the image; `UserNotificationsServer` secure-copies it to a preview path, invoking the QuickLook/UserNotifications thumbnail provider.  
- **Execution Vector:** In-process thumbnail/decoder path (QuickLook/UserNotifications → HEIF→ASTC decoder → `ATXEncoder` / WebKit) processes the malformed payload, leading to code execution.

--

### Log Evidence

**MessagesBlastDoorService**  
`Unpacking image with software HEIF -> ASTC decoder`

---

### User Notifications Server
**Action:** Will stage attachment file via secure copy  
**File URL:**  
`file:///var/mobile/tmp/com.apple.messages/IMG_0708-preview.ktx`

---

## Annotation

- `MessagesBlastDoorService` log shows auto-decoding activity during staging.  
- `UserNotificationsServer` log shows the secure-copy staging step, which triggers thumbnail generation and decoder invocation.  

### Outcome
- **Confirmed impact:** Heap corruption in `ATXEncoder` and WebKit during thumbnail generation results in **reliable zero-click remote code execution**.

---

### **Stage 3: WebKit Exploitation & Sandbox Bypass (CVE-2025-24201)**

- **Component Affected:** `com.apple.WebKit.WebContent`
- **Behavior:** Malicious payload causes resource lookup bypass.
- **Leak Example:**
```
debug 2025-01-09 09:41:29.993302 -0500 com.apple.WebKit.WebContent 
Resource lookup: file:///System/Library/PrivateFrameworks/WebCore.framework/modern-media-controls/images/airplay-placard@3x.png
```

---

### **Stage 4: Kernel Manipulation via Core Media (CVE-2025-24085)**

- **Affected Subsystems:**
  - `mediaplaybackd` pipeline reconfiguration.
  - `codecctl` register manipulation.
  - Temporary buffer exhaustion in `IOHIDInterface`.

#### **Example Kernel Logs**
```
fpfs_ConfigureRatePlan: requested rate 0.000 => using rate 1.000
codecctl: Error reading register 0x00000000
IOHIDInterface: Creating temporary buffer for report data
```

- **Outcome:** Heap corruption used to overwrite critical pointers → root execution context achieved.

---

### **Stage 5: Subsystem Bricking and Persistent Access**

- **Bricking Vector:** Modification of `IODeviceTree` entries.
- **Persistence Vectors:**
  - Wi-Fi proxy hijack via `wifid`
  - `launchd` respawning of rogue services
  - CloudKeychainProxy tampering

#### **Persistence Logs**
```
CloudKeychainProxy: Getting object for key <redacted>
wifid: overrideWoWState 0 - Forcing proxy override
Device assigned IP: 172.16.101.176 (rogue subnet)
```

- **Device Brick Trigger:**
```
"IOAccessoryPowerSourceItemBrickLimit" = 0
```

---

##  Indicators of Compromise (IOCs)

**Network Artifacts**
- IPs:
  - `172.16.101.176` – spoofed rogue subnet
  - `172.16.101.254` – attacker-controlled router

**System Artifacts**
- Unauthorized requests from WebKit to internal assets.
- CloudKeychainProxy access outside expected usage.
- Modified proxy settings in `wifid`.

**.ips Diagnostic Summary**
- High memory pressure and kernel panics post-execution.
- Background service shutdowns (e.g., `mediaremoted`, `mobileassetd`).

**Log Evidence**
https://ia600508.us.archive.org/8/items/cve-2025-24085-24201/cve%202025-24085%3B%2024201.mov

---

##  Vendor Patch Timeline

| Date          | CVE            | Description                              | Status     |
|---------------|----------------|------------------------------------------|------------|
| Dec 18, 2024  | -              | Working exploit reported to Apple        | n/a        |
| Feb 20, 2025  | CVE-2025-24085 | Core Media privilege escalation patched  | Resolved   |
| Mar 7, 2025   | CVE-2025-24201 | WebKit RCE memory protections updated    | Resolved   |

**Patch Summary:**
- Core Media: UAF resolved via memory management hardening.
- WebKit: Heap overflow mitigated, stronger sandbox rules enforced.

---

##  Comparison to Operation Triangulation

| Exploit Feature                  | Operation Triangulation | Glass Cage (2025) |
|----------------------------------|--------------------------|-------------------|
| Zero-Click PNG/HEIF Delivery     | Yes                      | Yes               |
| BlastDoor Sandbox Bypass         | Yes                      | Yes               |
| WebKit Heap Exploitation         | Yes                      | Yes               |
| Keychain Exfiltration            | Partial                  | Full              |
| Network Hijacking via wifid      | No                       | Yes               |
| Persistent Subsystem Injection   | No                       | Yes               |
| Bricking Mechanism               | No                       | Yes               |

---

## Recommendations

### **Short-Term Mitigation**
- Immediately update to iOS versions >18.2.1.
- Audit `wifid` and `CloudKeychainProxy` logs for unauthorized access.
- Revoke device certificates and tokens exposed during the exploit.

### **Long-Term Defensive Strategy**
- Harden `MessagesBlastDoorService` against malformed metadata.
- Enforce sandbox boundaries in WebKit for non-browser contexts (e.g., image previews).
- Improve image validation logic across `ATXEncoder`, `PreviewImageUnpacker`.
- Introduce runtime anomaly detection for `codecctl`, `IOHIDInterface`, and `mediaplaybackd`.

---

## **Conclusion**

The **Glass Cage exploit chain** demonstrates a critical **zero-click RCE path** through **iMessage**, allowing **full kernel takeover**, **keychain compromise**, and **persistent network hijack** with the potential for **device bricking**.

Despite partial mitigations in February and March of 2025, the attack operated freely for several weeks, highlighting the challenges in securing complex message-handling and media-processing pipelines in iOS.

---


